int alpha = PREFIX(alpha);
float intensity = float(alpha)/100.0;
#define ChannelBlend_Exclusion(B,L)  ((B + L - ((B * L)*2.0f)))

vec3 AdjustforJigsaw_PurpleGreen(vec3 rgb)
{
	vec3 outputCol; 
	outputCol.x = ChannelBlend_Exclusion(58.0/256.0, rgb.x );
	outputCol.y = ChannelBlend_Exclusion(15.0/256.0, rgb.y);
	outputCol.z = ChannelBlend_Exclusion(34.0/256.0, rgb.z);
	return outputCol; 
}

vec3 AdjustforJigsaw_BrownGray(vec3 rgb)
{
	vec3 outputCol; 
	outputCol.x = ChannelBlend_Exclusion(21.0/256.0, rgb.x);
	outputCol.y = ChannelBlend_Exclusion(59.0/256.0, rgb.y);
	outputCol.z = ChannelBlend_Exclusion(79.0/256.0, rgb.z);
	return outputCol; 
}

vec3 AdjustforJigsaw_BrownGreen(vec3 rgb)
{
	vec3 outputCol; 
	outputCol.x= ChannelBlend_Exclusion(14.0/256.0, rgb.x);
	outputCol.y = ChannelBlend_Exclusion(24.0/256.0, rgb.y);
	outputCol.z = ChannelBlend_Exclusion(63.0/256.0, rgb.z);
	return outputCol; 
}

vec3 AdjustforJigsaw_BlueGreen(vec3 rgb)
{
	vec3 outputCol; 
	outputCol.x = ChannelBlend_Exclusion(75.0/256.0, rgb.x);
	outputCol.y = ChannelBlend_Exclusion(46.0/256.0, rgb.y);
	outputCol.z = ChannelBlend_Exclusion(17.0/256.0, rgb.z);
	return outputCol; 
}

vec4 FUNCNAME(vec2 tc)
 {
    vec4 textureColor = INPUT(tc);
    vec4 fragOutCol;
	vec2 uv = tc;
    vec4 inColor = INPUT( uv );
	vec4 col = vec4(0.0);
	float W = iResolution.x;
	float H = iResolution.y;
	
	float whiteGap = 0.00625/2.0;
	float colorGapX = 0.496875;
	float whiteGapY = whiteGap*W*1.0/H;
	float colorGapY = (1.0 - whiteGapY)/2.0;
	
	if( uv.x<colorGapX && uv.y< colorGapY )
		col.xyz = AdjustforJigsaw_PurpleGreen(inColor.xyz); 
	else if( uv.x > colorGapX+whiteGap && uv.y< colorGapY )
		col.xyz = AdjustforJigsaw_BrownGreen(inColor.xyz); 
	else if ( uv.x<colorGapX && uv.y > colorGapY + whiteGapY )
		col.xyz = AdjustforJigsaw_BrownGray(inColor.xyz); 
	else if ( uv.x > colorGapX + whiteGap  && uv.y > colorGapY + whiteGapY )
		col.xyz = AdjustforJigsaw_BlueGreen(inColor.xyz); 
	else col.xyz = vec3(0.0);
	col.a = inColor.a;

	 return vec4(inColor.rgb, inColor.a)*(1.0 - intensity) + vec4(col.rgb, inColor.a)*intensity;
 }
 